function NRQuickStart() {
    let self = this;
    self.isInit = false;
    self.docType = docType;
    self.injectWidget = injectWidget;
    self.isAsyncFunction = isAsyncFunction;
    self.getHasQuickStart = getHasQuickStart;
    self.asyncFunctions = ['getHasQuickStart'];
    self.isQuickStartShowFullText = JSON.parse(isQuickStartShowFullText);
    $(document).ready(function() {
        if (typeof nrExtWidget != 'undefined') {
            return;
        } else {
            self.injectWidget();
        }
    });
    function injectWidget() {
        if (!self.isInit) {
            try {
                const widget = document.createElement("DIV");
                widget.id = 'ext-widget';
                widget.style.zIndex = '9876543210';
                widget.innerHTML = '<div class="ext-inner-widget widget-play" id="widget-play">' +
                    '<div class="ext-widget-icon">' +
                    '<svg class="ext-icon icon-play" id="widget-icon">' +
                    '<use xlink:href="#play_circle_filled"></use>' +
                    '</svg>' +
                    '</div>' +
                    '<div class="ext-widget-text" id="widget-text-init">Listen to webpage</div>' +
                    '</div>' +
                    '<div class="ext-inner-widget widget-exit">' +
                    '<div class="ext-widget-icon" id="nr-quick-start-exit">' +
                    '<svg class="ext-icon icon-exit">' +
                    '<use xlink:href="#power_settings_new"></use>' +
                    '</svg>' +
                    '</div>' +
                    '<div class="ext-widget-text" id="widget-text">Listen to webpage</div>' +
                    '</div>';
                widget.classList.add("ext-widget");
                if (self.isQuickStartShowFullText) {
                    widget.classList.add("init");
                }
                const playIconSvg = document.createElement("SVG");
                const xmlDoc = new DOMParser().parseFromString(
                    '<svg width="0" height="0" class="hidden">' +
                    '<symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64" id="play_circle_filled">' +
                    '<path d="M32 5.333C17.28 5.333 5.333 17.28 5.333 32 5.333 46.72 17.28 58.667 32 58.667c14.72 0 26.667-11.947 26.667-26.667C58.667 17.28 46.72 5.333 32 5.333zm-5.333 36V22.667c0-1.094 1.253-1.734 2.133-1.067l12.453 9.333c.72.534.72 1.6 0 2.134L28.8 42.4c-.88.667-2.133.027-2.133-1.067z" fill="#134DCD"></path>' +
                    '</symbol>' +
                    '<symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="power_settings_new">' +
                    '<path d="M12 3c-.55 0-1 .45-1 1v8c0 .55.45 1 1 1s1-.45 1-1V4c0-.55-.45-1-1-1zm5.14 2.86a.99.99 0 00-.01 1.39c1.13 1.2 1.83 2.8 1.87 4.57.09 3.83-3.08 7.13-6.91 7.17A6.981 6.981 0 015 12c0-1.84.71-3.51 1.87-4.76.37-.39.37-1-.01-1.38a.993.993 0 00-1.43.02A8.92 8.92 0 003 11.74c-.14 4.88 3.83 9.1 8.71 9.25 5.1.16 9.29-3.93 9.29-9 0-2.37-.92-4.51-2.42-6.11-.38-.41-1.04-.42-1.44-.02z">' +
                    '</path>' +
                    '</symbol></svg>', "text/xml"
                )
                document.body.appendChild(xmlDoc.documentElement);
                const quickStartExitOptions = document.createElement("DIV");
                quickStartExitOptions.id = "nr-ext-quick-start-exit-options";
                quickStartExitOptions.classList.add("nr-ext-quick-start-exit-options");
                quickStartExitOptions.style.zIndex = '9876543210';
                quickStartExitOptions.innerHTML = `
                <div class="nr-ext-quick-start-exit-options-content">
                    <h4 class="nr-ext-quick-start-exit-options-header">Hide quickstart widget?</h4>
                    <p>If you choose to hide indefinitely (option 2 or 3), you can unhide this feature under <b>“Preferences”</b> in your account.</p>
                    <div class="nr-ext-quick-start-exit-options-box">
                        <div class="nr-ext-quick-start-exit-options-cell">
                            <input type="radio" name="quick-start-exit-options" id="nr-quick-start-exit-once" value="exit-once" checked="true"> 
                            <label for="nr-quick-start-exit-once">Hide just once only</label>
                        </div>
                        <div class="nr-ext-quick-start-exit-options-cell">
                            <input type="radio" name="quick-start-exit-options" id="nr-quick-start-exit-this-page" value="exit-page">
                            <label for="nr-quick-start-exit-this-page">Hide on this page indefinitely until you unhide it</label>
                        </div>
                        <div class="nr-ext-quick-start-exit-options-cell">
                            <input type="radio" name="quick-start-exit-options" id="nr-quick-start-exit-forever" value="exit-forever">
                            <label for="nr-quick-start-exit-forever">Hide indefinitely on all pages that you visit</label>
                        </div>                
                    </div>
                    <div class="nr-ext-quick-start-exit-options-footer">
                        <button class="ext-link-button" id="nr-ext-quick-start-exit-cancel">Cancel</button>
                        <button class="ext-primary-button" id="nr-ext-quick-start-exit-confirm">Confirm</button>
                    </div>
                </div>`;
                quickStartExitOptions.style.display = 'none';
                document.body.appendChild(widget);
                document.body.appendChild(playIconSvg);
                document.body.appendChild(quickStartExitOptions);
                const widgetTextInit = document.getElementById("widget-text-init");
                const widgetText = document.getElementById("widget-text");
                if (self.docType === 'google doc') {
                    widgetTextInit.innerText = 'Listen to Google Docs';
                    widgetText.innerText = 'Listen to Google Docs'
                } else {
                    widgetTextInit.innerText = 'Listen to webpage';
                    widgetText.innerText = 'Listen to webpage'
                }
                var text_width = $('#widget-text').width() + 10;
                var rightS = (-1 * text_width) + 'px';
                if (self.isQuickStartShowFullText) {
                    setTimeout(() => {
                        $('.ext-widget').removeClass('init');
                        $('#ext-widget').css('right', rightS);
                    }, 1000);
                } else {
                    $('.ext-widget').removeClass('init');
                    $('#ext-widget').css('right', rightS);
                }
                isInit = true;
                widgetTextInit.onclick = () => {
                    chrome.runtime.sendMessage({fn: "injectWidgetAndRead"});
                }
                widgetText.onclick = () => {
                    chrome.runtime.sendMessage({fn: "injectWidgetAndRead"});
                }
                const exitOptionsButton = document.getElementById("nr-quick-start-exit");
                exitOptionsButton.onclick = () => {
                    quickStartExitOptions.style.display = 'flex';
                }
                const exitOptionsCancelButton = document.getElementById("nr-ext-quick-start-exit-cancel");
                exitOptionsCancelButton.onclick = () => {
                    quickStartExitOptions.style.display = 'none';
                }
                const exitOptionsConfirmButton = document.getElementById("nr-ext-quick-start-exit-confirm");
                exitOptionsConfirmButton.onclick = () => {
                    const selectedOption = $('input[name="quick-start-exit-options"]:checked').val();
                    if (selectedOption === 'exit-once') {
                        widget.remove();
                        quickStartExitOptions.remove();
                    } else if (selectedOption === 'exit-page') {
                        widget.remove();
                        quickStartExitOptions.remove();
                        chrome.runtime.sendMessage({fn: 'addQuickStartBlackList'}, () => void chrome.runtime.lastError);
                    } else if (selectedOption === 'exit-forever') {
                        widget.remove();
                        quickStartExitOptions.remove();
                        chrome.runtime.sendMessage({fn: 'setWidgetSetting', key: 'isQuickStartWebpage', value: false}, () => void chrome.runtime.lastError);
                        chrome.runtime.sendMessage({fn: 'setWidgetSetting', key: 'isQuickStartGoogleDocs', value: false}, () => void chrome.runtime.lastError);
                    }
                }
                chrome.runtime.sendMessage({fn: 'setWidgetSetting', key: 'isQuickStartShowFullText', value: false}, () => void chrome.runtime.lastError);
            } catch (err) {
            }
        }
    }
    function getHasQuickStart(request, sender, sendResponse) {
        sendResponse(self.isInit);
    }
    chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
        if (request.fn in nrQuickStart) {
            nrQuickStart[request.fn](request, sender, sendResponse);
            if (nrQuickStart.isAsyncFunction(request.fn)) {
                return true;
            }
        } else if (request.message === 'injectWidget') {
            const widget = document.getElementById("ext-widget");
            const quickStartExitOptions = document.getElementById("nr-ext-quick-start-exit-options");
            widget.remove();
            quickStartExitOptions.remove();
        }
    });
    function isAsyncFunction(fnName) {
        return self.asyncFunctions.includes(fnName);
    }
}
var nrQuickStart = nrQuickStart || new NRQuickStart();